#ifndef __ADRENALIN__HEADER__
#define __ADRENALIN__HEADER__

#include "pch.h"

#include "FTNStruc.hpp"
#include "Common.hpp"
#include "Links.h"
#include "Areas.h"
#include "Lng.hpp"
#include "Tic.hpp"
#include "actions\Action.h"
#include "exceptions.h"

const
    // Action
    ACTION_NONE       = 0x0000,
    ACTION_FIX        = 0x0002,
    ACTION_TOSS       = 0x0004,
    ACTION_HATCH      = 0x0008,
    ACTION_REPORT     = 0x0010,
    ACTION_ERROR      = 0x0020,
    ACTION_DEBUG      = 0x0040,
    ACTION_PURGE      = 0x0080,
    ACTION_TIMEPURGE  = 0x0100,
    ACTION_BASEPURGE  = 0x0200,
    ACTION_RELINK     = 0x0400,
    ACTION_HAND       = 0x0800,
    ACTION_TOSS_BAD   = 0x2000;

    // ErrorCode
enum enErrorCodes {
	ERROR_NONE,
	ERROR_UNKNOWN_ARG,
	ERROR_HATCH_NO_FILE_DEF,
	ERROR_HATCH_NO_AREA_DEF,
	ERROR_HATCH_EXTRA_ARG,
	ERROR_SYNTAX,
	ERROR_NUMBER,
	ERROR_DUPLICATE,
	ERROR_FILE_ABSENT,
	ERROR_UNKNOWN_KEYWORD,
	ERROR_FORWARD_DEF,
	ERROR_ABSENT_DEF,
	ERROR_MEMORY,
	ERROR_AREA_NOT_FOUND,
	ERROR_MOVE_FAILED,
	ERROR_CRC32_FAILED,
	ERROR_ALREADY_WORK_REEEEEEEEEEEEEEMMMMMMMMMOOOOOOOOOOOOOVEEEEEEEEEEEE,
	ERROR_UNKNOWN_AKA,
	ERROR_LNG_READ,
	ERROR_LNG_FILE_NOT_FOUND,
	ERROR_LNG_NUMBER,
	ERROR_HATCH_NO_DESC_DEF,
	ERROR_HATCH_NO_REPLACES,
	ERROR_UNKNOWN_OPT,
	ERROR_LOW_DISK_SPACE,
	ERROR_UNDEFINED_ADDRESS,	// RELINK without address
	ERROR_WRONG_ADDRESS,		// RELINK with wrong address
	ERROR_TIMEPURGE_NO_HOURS,	// hours for TimePurge not defined
	ERROR_TIMEPURGE_INVALID_HOURS,	// invalid hours for TimePurge
	// BasePurge errors
	ERROR_BASEPURGE_NO_DAYS,		// <days> weren't specified
	ERROR_BASEPURGE_INVALID_DAYS,		// invalid <days> value
	// Hand
	ERROR_HAND_NO_LINK,
	ERROR_HAND_NO_COMMANDS,
	// change group
	ERROR_FEW_ARGUMENTS
};


struct SForwardInfo {
	TCHAR	m_szDate[7];
	TCHAR	m_szLink[80];
	TCHAR	m_szArea[MAX_AREA_SIZE];
};

typedef vector<SForwardInfo>	CForwardInfoVector;

struct SDiskLimit {
	TCHAR	m_szRoot[MAX_PATH];
	DWORD	m_dwLimit;
	SDiskLimit() {}
	SDiskLimit(const SDiskLimit& diskLimit) : m_dwLimit(diskLimit.m_dwLimit)
	{
		lstrcpy( m_szRoot, diskLimit.m_szRoot );
	}
	SDiskLimit& operator =(const SDiskLimit& diskLimit) {
		m_dwLimit = diskLimit.m_dwLimit;
		lstrcpy( m_szRoot, diskLimit.m_szRoot );
		return (*this);
	}
};


// config file names list
struct SCfgFile {
	char      m_szName[MAX_PATH];  // config file name
	int       m_iSkipLines;       // lines to skip
	SCfgFile() {
		m_szName[0] = _T('\0');
		m_iSkipLines = 0;
	}
	SCfgFile(const SCfgFile& cfgFile) {
		lstrcpy( m_szName, cfgFile.m_szName );
		m_iSkipLines = cfgFile.m_iSkipLines;
	}
	SCfgFile& operator =(const SCfgFile& cfgFile) {
		lstrcpy( m_szName, cfgFile.m_szName );
		m_iSkipLines = cfgFile.m_iSkipLines;
		return (*this);
	}
};


class CAdrenalin {
public:
	static tstring getName();

	CAdrenalin(int argc, TCHAR **argv);
	~CAdrenalin();

	static CAdrenalin& getInstance();

	int	Execute();

	CLng         m_language;

	static LPCTSTR getStartupPath()  { return m_szStartupPath; }
	static LPCTSTR getStartupDrive() { return m_szStartupDrive; }

    bool ParseLinkAddr(LPCTSTR s, SFTNAddress &Addr);

	BYTE*	getFileBuffer()				{ return m_fileBuffer;     }
	DWORD	getFileBufferSize() const	{ return m_fileBufferSize; }

protected:
	/**
	 * Start time (kept in constructor)
	 */
	SYSTEMTIME	startTime;

	/**
	 * File buffer is used to copy/move files
	 */
	BYTE*	m_fileBuffer;
	DWORD	m_fileBufferSize;

	struct SRelinkData {
		tstring	address;
		tstring	robotName;
	};

	SRelinkData	relinkData;

	// forwards-related stuff

	CForwardInfoVector	m_vectForwardInfo;
	bool			m_fForwardsRead;
	bool			m_fForwardsChanged;
	void			LoadForwards();
	void			SaveForwards();

	int	Relink();

	void GetErrorMessage(int nErrorCode, LPTSTR szMessage);

	// time purging
	
	struct STimePurge {
		int		m_iHours;
		VTString	m_vsMasks;
	};

	STimePurge	m_timePurge;

	// base purging

	struct SBasePurge {
		int		m_iDays;
		VTString	m_vsAreas;
	};
	SBasePurge	m_basePurge;

	// Hand commands

	struct SHandCommands {
		tstring		m_sAddr;
		VTString	m_vsCommands;
	};
	SHandCommands	m_handCommands;

	void UpdateFilesDB();

    /**
     * Filename of requests log
     */
    TCHAR   requestsLogFileName[MAX_PATH];

	virtual void checkTempBSO();

	void formatLogTime(const SYSTEMTIME& someTime, LPTSTR timeString);

private:
    DWORD        m_dwAction;
    int          m_iErrorCode;

	static TCHAR	m_szStartupPath[MAX_PATH];
	static TCHAR	m_szStartupDrive[3];		// <letter>':''\0'

	/* Enclosing quotes will be removed.
	 * If path doesn't forwarded by drive, drive will be added
	 * (with startup path, if the first letter of the path is not slash).
	 * Returns false if path is empty, true otherwise
	 */
	bool CorrectPath(LPTSTR szPath);
	
	/**
	 * Remove double quotes, check empty names and names with path separator.
	 * @return	true if name is correct, false otherwise
	 */
	bool CAdrenalin::CorrectName(LPTSTR szName);
    
    TCHAR   m_szLngFileName[MAX_PATH];

    TCHAR	m_szHatchFile[MAX_PATH];
    TCHAR	m_szHatchArea[MAX_PATH];
    TCHAR	m_szHatchDesc[MAX_PATH];
    TCHAR	m_szHatchReplaces[MAX_PATH];
    bool	m_fLeaveHatchedFile;

    vector<tstring>	m_vsPurgeAreas;
    
    vector<SDiskLimit>	m_vDiskLimits;

    // FileFlag data

    VTString	m_vsFileFlags;
    VTString	m_vsFileMasks;
    VTString	m_vsFileAreas;

    VTString		m_vsCommonFileFlags;
    VTString		m_vsCommonFileMasks;
    vector<bool>	m_vbCommonFileFlagsUsed;

	/**
	 * Flag indicating that we are tossing bad tics (from badtics directory)
	 */
	bool	tossingBadTics;

	deque<ActionPtr>	actions;

    void ParseAppCfg();

    void CheckDiskLimits();

    void ParseCmdLine(int argc, TCHAR **argv);
    
    // bool ParseAreaAccess(LPCTSTR s, SArea &Area);
    
    void PrintDebugInfo();

    void ProcessFixRequests(bool flagByHand = false);

    /**
     * Treats already processed TIC (removes file or copies it to the special
     * directory, if ProcessedTicsPath is specified).
     * @param   fullTicName     full name of TIC file
     * @param   onlyNameFrom    position in fullTicName where just name (without path)
     *                          starts
     * @param   processedTicsNamer  used to get new index to form TIC name 
     *                              while renaming TIC
     */
    void TreatProcessedTic(LPCTSTR fullTicName, int onlyNameFrom, CTicNamer& processedTicsNamer);

	/**
	 * @param	ticsPath	path to look for tics
	 * @param	filesPath	path to look for files for tics
     */
    void ProcessInboundTics(LPCTSTR ticsPath, LPCTSTR filesPath);

	/**
	 * @param	tic			tic to process
	 * @param	filePath	path to look for file for tic
     */
    virtual bool processTic(CTic& tic, const tstring& filePath);

    int Hatch();
	int	HatchSingleFile(LPCTSTR fileName, LPCTSTR fileDesc);


	void Purge();
	void TimePurge();
	void BasePurge();

    void AddStartupPath(LPTSTR szLocation);

    bool SaveCfg();

    void  MoveTicToBads(LPCTSTR szFullTicName, int TicNameFrom);
    inline bool IsEmptyStr(LPCTSTR szData) { return (szData[0] == _T('\0')); }

    SFTNAddress& GetOurAddr(int iOurAddr);

    bool AssignFileFlags();

	void ProcessResendCommand(PLink link, SMsgData& msgData, vector<tstring>& bodyLines);

	// methods used by ProcessResendCommand

	/**
	 * @return	false when cannot parse tail (for example, no area specified or invalid file mask specified)
	 */
	bool ParseResendCommandTail(const tstring& tail, tstring& areaName, vector<tstring>& fileMasks);
	void ReadFilesList(LPCTSTR areaPath, const vector<tstring>& fileMasks, vector<tstring>& files, vector<tstring>& descriptions);

	/**
	 * @return	true if tic is older than max tic age (in hours)
	 */
	bool isTicOld(LPCTSTR ticFileName, int maxTicAge);	
};

extern CAdrenalin*	pAdrenalin;

#endif